package nemosofts.voxradio.activity;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.media.MediaMetadataRetriever;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.StatFs;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

import androidx.activity.EdgeToEdge;
import androidx.activity.OnBackPressedCallback;
import androidx.annotation.OptIn;
import androidx.appcompat.widget.Toolbar;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.media3.common.util.UnstableApi;
import androidx.nemosofts.AppCompatActivity;
import androidx.nemosofts.utils.DeviceUtils;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import java.io.File;
import java.util.ArrayList;

import nemosofts.voxradio.R;
import nemosofts.voxradio.adapter.AdapterRecorder;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.item.ItemRecorder;
import nemosofts.voxradio.utils.ApplicationUtil;
import nemosofts.voxradio.utils.AsyncTaskExecutor;
import nemosofts.voxradio.utils.IfSupported;
import nemosofts.voxradio.utils.RecorderPlayer;
import nemosofts.voxradio.utils.helper.Helper;

public class RecorderActivity extends AppCompatActivity {

    private RecyclerView rv;
    private AdapterRecorder adapter;
    private ArrayList<ItemRecorder> arrayList;
    private ProgressBar progressbar;
    private FrameLayout frameLayout;

    private ProgressBar pbData;
    private TextView usedData;
    private TextView totalData;
    private final Handler handlerSeries = new Handler(Looper.getMainLooper());
    private int progressStatusOld = 0;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        IfSupported.isRTL(this);
        IfSupported.isScreenshot(this);
        EdgeToEdge.enable(this);
        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.bg_page), (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
            return insets;
        });

        Toolbar toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        if (getSupportActionBar() != null) {
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            getSupportActionBar().setDisplayShowHomeEnabled(true);
        }
        toolbar.setNavigationOnClickListener(view -> onBack());

        arrayList = new ArrayList<>();
        progressbar = findViewById(R.id.pb);
        frameLayout = findViewById(R.id.fl_empty);

        pbData = findViewById(R.id.pb_data);
        pbData.setMax(100);
        usedData = findViewById(R.id.tv_used_data);
        totalData = findViewById(R.id.tv_total_data);

        rv = findViewById(R.id.rv);
        GridLayoutManager grid = new GridLayoutManager(RecorderActivity.this, 1);
        boolean isLandscape = DeviceUtils.isLandscape(RecorderActivity.this);
        grid.setSpanCount(isLandscape ? 2 : 1);
        rv.setLayoutManager(grid);
        rv.setItemAnimator(new DefaultItemAnimator());

        new LoadDownloadSongs().execute();

        LinearLayout adView = findViewById(R.id.ll_adView);
        new Helper(this).showBannerAd(adView,"");

        OnBackPressedCallback callback = new OnBackPressedCallback(true) {
            @Override
            public void handleOnBackPressed() {
                onBack();
            }
        };
        getOnBackPressedDispatcher().addCallback(this, callback);
    }

    private void onBack() {
        RecorderPlayer.onStopAudio();
        finish();
    }

    @Override
    public int setContentViewID() {
        return R.layout.activity_recorder;
    }

    private class LoadDownloadSongs extends AsyncTaskExecutor<String, String, String> {

        @Override
        protected void onPreExecute() {
            if (!arrayList.isEmpty()){
                arrayList.clear();
            }
            frameLayout.setVisibility(View.GONE);
            progressbar.setVisibility(View.VISIBLE);
            super.onPreExecute();
        }

        @Override
        protected String doInBackground(String strings) {
            try {
                String iconsStoragePath = Environment.getExternalStorageDirectory().toString()
                        + File.separator
                        + Environment.DIRECTORY_DOWNLOADS
                        + File.separator
                        + getString(R.string.app_name
                );
                File root = new File(iconsStoragePath);
                File[] songs = root.listFiles((dir, name) -> name.endsWith(".mp3"));
                if (songs != null) {
                    for (int i = 0; i < songs.length; i++) {
                        MediaMetadataRetriever md = new MediaMetadataRetriever();
                        md.setDataSource(songs[i].getAbsolutePath());
                        String title = songs[i].getName();
                        String duration = md.extractMetadata(MediaMetadataRetriever.METADATA_KEY_DURATION);
                        if (duration != null) {
                            duration = ApplicationUtil.milliSecondsToTimerDownload(Long.parseLong(duration));
                        }
                        String url = songs[i].getAbsolutePath();
                        long fileSize = songs[i].length();
                        arrayList.add(new ItemRecorder(String.valueOf(i), url, title, duration, fileSize));
                    }
                }
                return "1";
            } catch (Exception e) {
                return "0";
            }
        }

        @SuppressLint("NotifyDataSetChanged")
        @Override
        protected void onPostExecute(String s) {
            if (isFinishing()){
                return;
            }
            if (!arrayList.isEmpty()){
                adapter = new AdapterRecorder(RecorderActivity.this, arrayList, new AdapterRecorder.RecyclerItemClickListener() {
                    @OptIn(markerClass = UnstableApi.class)
                    @Override
                    public void onClickListener(ItemRecorder itemData, int position) {
                        Callback.getArrayListRecording().clear();
                        Callback.setArrayListRecording(arrayList);
                        Callback.setPlayPosRecording(position);
                        adapter.notifyDataSetChanged();
                        if (PlayerService.getExoPlayer() != null && PlayerService.getExoPlayer().getPlayWhenReady()) {
                            Intent intent = new Intent(getApplicationContext(), PlayerService.class);
                            intent.setAction(PlayerService.ACTION_STOP);
                            startService(intent);
                        }
                    }

                    @Override
                    public void onDeleteListener() {
                        updateStorageInfo(true);
                        setEmpty();
                    }
                });
                rv.setAdapter(adapter);
                progressbar.setVisibility(View.GONE);
            }
            updateStorageInfo(false);
            setEmpty();
        }
    }

    @Override
    public void onDestroy() {
        RecorderPlayer.onStopAudio();
        super.onDestroy();
    }

    public void setEmpty() {
        if (!arrayList.isEmpty()) {
            rv.setVisibility(View.VISIBLE);
            frameLayout.setVisibility(View.GONE);
            progressbar.setVisibility(View.GONE);
        } else {
            rv.setVisibility(View.GONE);
            frameLayout.setVisibility(View.VISIBLE);
            progressbar.setVisibility(View.INVISIBLE);

            frameLayout.removeAllViews();
            LayoutInflater inflater = (LayoutInflater) getSystemService(Context.LAYOUT_INFLATER_SERVICE);

            @SuppressLint("InflateParams") View myView = inflater.inflate(R.layout.row_empty, null);

            myView.findViewById(R.id.ll_empty_try).setOnClickListener(v -> {
                myView.findViewById(R.id.iv_empty).setVisibility(View.GONE);
                myView.findViewById(R.id.pb_empty).setVisibility(View.VISIBLE);
                new Handler().postDelayed(() -> {
                    myView.findViewById(R.id.iv_empty).setVisibility(View.VISIBLE);
                    myView.findViewById(R.id.pb_empty).setVisibility(View.GONE);
                    new LoadDownloadSongs().execute();
                }, 500);
            });

            frameLayout.addView(myView);
        }
    }

    @SuppressLint({"SetTextI18n", "DefaultLocale"})
    private void updateStorageInfo(Boolean isDelete) {
        try {
            StatFs stat = new StatFs(Environment.getExternalStorageDirectory().getPath());
            long availableBytes = stat.getAvailableBytes();
            long totalBytes = stat.getTotalBytes();

            int progress = (int) ((availableBytes * 100) / totalBytes);

            if (Boolean.FALSE.equals(isDelete)){
                progressStatusOld = 0;
                handlerSeries.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if (progressStatusOld < 100 - progress) {
                            progressStatusOld++;
                            pbData.setProgress(progressStatusOld);
                            handlerSeries.postDelayed(this, 10);
                        }
                    }
                }, 10);
            } else {
                pbData.setProgress(100 - progress);
            }

            double availableGB = availableBytes / (1024.0 * 1024.0 * 1024.0);
            double totalGB = totalBytes / (1024.0 * 1024.0 * 1024.0);

            usedData.setText(String.format("%.2f GB", availableGB) + " Available Storage");
            totalData.setText(String.format("%.2f GB", totalGB) + " total . Internal Storage");

            findViewById(R.id.ll_storage).setVisibility(View.VISIBLE);
        } catch (Exception e) {
            findViewById(R.id.ll_storage).setVisibility(View.GONE);
        }
    }
}